/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.events;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.BitmapFont;
import com.badlogic.gdx.graphics.g2d.GlyphLayout;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.helpers.FontHelper;
import com.megacrit.cardcrawl.helpers.ImageMaster;
import com.megacrit.cardcrawl.helpers.MathHelper;
import com.megacrit.cardcrawl.ui.DialogWord;
import com.megacrit.cardcrawl.ui.buttons.LargeDialogOptionButton;
import java.util.ArrayList;
import java.util.Scanner;

public class GenericEventDialog {
    private Texture img = null;
    private static final float DIALOG_MSG_X_IMAGE = 816.0f * Settings.scale;
    private static final float DIALOG_MSG_W_IMAGE = 900.0f * Settings.scale;
    private Color panelColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private Color titleColor = new Color(1.0f, 0.835f, 0.39f, 0.0f);
    private Color borderColor = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private Color imgColor = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    private float animateTimer = 0.0f;
    private static final float ANIM_SPEED = 0.5f;
    private static boolean show = false;
    private String title = "";
    private static final float TITLE_X = 570.0f * Settings.scale;
    private static final float TITLE_Y = Settings.EVENT_Y + 408.0f * Settings.scale;
    private static float curLineWidth = 0.0f;
    private static int curLine = 0;
    private static DialogWord.AppearEffect a_effect;
    private static Scanner s;
    private static GlyphLayout gl;
    private static ArrayList<DialogWord> words;
    private static boolean textDone;
    private static float wordTimer;
    private static final float WORD_TIME = 0.02f;
    private static final float CHAR_SPACING;
    private static final float LINE_SPACING;
    private static final float DIALOG_MSG_X_TEXT;
    private static final float DIALOG_MSG_Y_TEXT;
    private static final float DIALOG_MSG_W_TEXT;
    private static float DIALOG_MSG_X;
    private static float DIALOG_MSG_Y;
    private static float DIALOG_MSG_W;
    public BitmapFont descriptionFont = FontHelper.textOnlyEventBody;
    public static ArrayList<LargeDialogOptionButton> optionList;
    public static int selectedOption;
    public static boolean waitForInput;

    public void loadImage(String imgUrl) {
        this.img = ImageMaster.loadImage(imgUrl);
        DIALOG_MSG_X = DIALOG_MSG_X_IMAGE;
        DIALOG_MSG_W = DIALOG_MSG_W_IMAGE;
    }

    public void clearImage() {
        this.img = null;
        DIALOG_MSG_X = DIALOG_MSG_X_TEXT;
        DIALOG_MSG_Y = DIALOG_MSG_Y_TEXT;
        DIALOG_MSG_W = DIALOG_MSG_W_TEXT;
    }

    public void update() {
        this.animateIn();
        if (show && this.animateTimer == 0.0f) {
            for (int i = 0; i < optionList.size(); ++i) {
                optionList.get(i).update();
                if (!GenericEventDialog.optionList.get((int)i).pressed || !waitForInput) continue;
                selectedOption = i;
                GenericEventDialog.optionList.get((int)i).pressed = false;
                waitForInput = false;
            }
        }
        if (!Settings.lineBreakViaCharacter) {
            GenericEventDialog.bodyTextEffect();
        } else {
            GenericEventDialog.bodyTextEffectCN();
        }
        for (DialogWord w : words) {
            w.update();
        }
    }

    private void animateIn() {
        if (show) {
            this.animateTimer -= Gdx.graphics.getDeltaTime();
            if (this.animateTimer < 0.0f) {
                this.animateTimer = 0.0f;
            }
            this.panelColor.a = MathHelper.slowColorLerpSnap(this.panelColor.a, 1.0f);
            if (this.panelColor.a > 0.8f) {
                this.borderColor.a = this.titleColor.a = MathHelper.slowColorLerpSnap(this.titleColor.a, 1.0f);
                if (this.borderColor.a > 0.8f) {
                    this.imgColor.a = MathHelper.slowColorLerpSnap(this.imgColor.a, 1.0f);
                }
            }
        }
    }

    public static int getSelectedOption() {
        waitForInput = true;
        return selectedOption;
    }

    public static void hide() {
        show = false;
    }

    public static void show() {
        show = true;
    }

    public void clear() {
        show = false;
        this.clearImage();
        this.animateTimer = 0.0f;
        this.panelColor.a = 0.0f;
        this.titleColor.a = 0.0f;
        this.imgColor.a = 0.0f;
        this.borderColor.a = 0.0f;
        optionList.clear();
        words.clear();
        waitForInput = true;
    }

    public void show(String title, String text) {
        this.title = title;
        GenericEventDialog.updateBodyText(text);
        this.animateTimer = 0.5f;
        show = true;
    }

    public static void clearAllDialogs() {
        optionList.clear();
    }

    public static void removeDialogOption(int slot) {
        if (slot < optionList.size()) {
            optionList.remove(slot);
        }
        for (LargeDialogOptionButton b : optionList) {
            b.calculateY();
        }
    }

    public static void clearRemainingOptions() {
        for (int i = optionList.size() - 1; i > 0; --i) {
            optionList.remove(i);
        }
        for (LargeDialogOptionButton b : optionList) {
            b.calculateY();
        }
    }

    public static void setDialogOption(String text) {
        optionList.add(new LargeDialogOptionButton(optionList.size(), text));
        for (LargeDialogOptionButton b : optionList) {
            b.calculateY();
        }
    }

    public static void setDialogOption(String text, AbstractCard previewCard) {
        optionList.add(new LargeDialogOptionButton(optionList.size(), text, previewCard));
        for (LargeDialogOptionButton b : optionList) {
            b.calculateY();
        }
    }

    public static void setDialogOption(String text, boolean isDisabled) {
        optionList.add(new LargeDialogOptionButton(optionList.size(), text, isDisabled));
        for (LargeDialogOptionButton b : optionList) {
            b.calculateY();
        }
    }

    public static void setDialogOption(String text, boolean isDisabled, AbstractCard previewCard) {
        optionList.add(new LargeDialogOptionButton(optionList.size(), text, isDisabled, previewCard));
        for (LargeDialogOptionButton b : optionList) {
            b.calculateY();
        }
    }

    public static void updateDialogOption(int slot, String text) {
        optionList.set(slot, new LargeDialogOptionButton(slot, text));
    }

    public static void updateDialogOption(int slot, String text, AbstractCard previewCard) {
        optionList.set(slot, new LargeDialogOptionButton(slot, text, previewCard));
    }

    public static void updateBodyText(String text) {
        GenericEventDialog.updateBodyText(text, DialogWord.AppearEffect.BUMP_IN);
    }

    public static void updateBodyText(String text, DialogWord.AppearEffect ae) {
        s = new Scanner(text);
        words.clear();
        textDone = false;
        a_effect = ae;
        curLineWidth = 0.0f;
        curLine = 0;
    }

    private static void bodyTextEffectCN() {
        if ((wordTimer -= Gdx.graphics.getDeltaTime()) < 0.0f && !textDone) {
            wordTimer = 0.02f;
            if (s.hasNext()) {
                DialogWord.WordEffect effect;
                String word = s.next();
                if (word.equals("NL")) {
                    ++curLine;
                    curLineWidth = 0.0f;
                    return;
                }
                DialogWord.WordColor color = DialogWord.identifyWordColor(word);
                if (color != DialogWord.WordColor.DEFAULT) {
                    word = word.substring(2, word.length());
                }
                if ((effect = DialogWord.identifyWordEffect(word)) != DialogWord.WordEffect.NONE) {
                    word = word.substring(1, word.length() - 1);
                }
                for (int i = 0; i < word.length(); ++i) {
                    String tmp = Character.toString(word.charAt(i));
                    gl.setText(FontHelper.eventBodyText, tmp);
                    if (curLineWidth + GenericEventDialog.gl.width > DIALOG_MSG_W) {
                        ++curLine;
                        curLineWidth = GenericEventDialog.gl.width;
                    } else {
                        curLineWidth += GenericEventDialog.gl.width;
                    }
                    words.add(new DialogWord(FontHelper.eventBodyText, tmp, a_effect, effect, color, DIALOG_MSG_X + curLineWidth - GenericEventDialog.gl.width, DIALOG_MSG_Y - LINE_SPACING * (float)curLine, curLine));
                    if (show) continue;
                    words.get(words.size() - 1).dialogFadeOut();
                }
            } else {
                textDone = true;
                s.close();
            }
        }
    }

    private static void bodyTextEffect() {
        if ((wordTimer -= Gdx.graphics.getDeltaTime()) < 0.0f && !textDone) {
            wordTimer = 0.02f;
            if (s.hasNext()) {
                DialogWord.WordEffect effect;
                String word = s.next();
                if (word.equals("NL")) {
                    ++curLine;
                    curLineWidth = 0.0f;
                    return;
                }
                DialogWord.WordColor color = DialogWord.identifyWordColor(word);
                if (color != DialogWord.WordColor.DEFAULT) {
                    word = word.substring(2, word.length());
                }
                if ((effect = DialogWord.identifyWordEffect(word)) != DialogWord.WordEffect.NONE) {
                    word = word.substring(1, word.length() - 1);
                }
                gl.setText(FontHelper.eventBodyText, word);
                if (curLineWidth + GenericEventDialog.gl.width > DIALOG_MSG_W) {
                    ++curLine;
                    curLineWidth = GenericEventDialog.gl.width + CHAR_SPACING;
                } else {
                    curLineWidth += GenericEventDialog.gl.width + CHAR_SPACING;
                }
                words.add(new DialogWord(FontHelper.eventBodyText, word, a_effect, effect, color, DIALOG_MSG_X + curLineWidth - GenericEventDialog.gl.width, DIALOG_MSG_Y - LINE_SPACING * (float)curLine, curLine));
                if (!show) {
                    words.get(words.size() - 1).dialogFadeOut();
                }
            } else {
                textDone = true;
                s.close();
            }
        }
    }

    public void render(SpriteBatch sb) {
        if (show && !AbstractDungeon.player.isDead) {
            sb.setColor(this.panelColor);
            sb.draw(AbstractDungeon.eventImg, (float)Settings.WIDTH / 2.0f - 881.0f - 12.0f * Settings.scale, Settings.EVENT_Y - 403.0f + 64.0f * Settings.scale, 881.5f, 403.0f, 1763.0f, 806.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 1763, 806, false, false);
            if (this.img != null) {
                sb.setColor(this.imgColor);
                sb.draw(this.img, 460.0f * Settings.scale - 300.0f, Settings.EVENT_Y - 300.0f + 16.0f * Settings.scale, 300.0f, 300.0f, 600.0f, 600.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 600, 600, false, false);
                sb.setColor(this.borderColor);
                sb.draw(ImageMaster.EVENT_IMG_FRAME, 460.0f * Settings.scale - 305.0f, Settings.EVENT_Y - 305.0f + 16.0f * Settings.scale, 305.0f, 305.0f, 610.0f, 610.0f, Settings.scale, Settings.scale, 0.0f, 0, 0, 610, 610, false, false);
            }
            FontHelper.renderFontCentered(sb, FontHelper.textOnlyEventTitle, this.title, TITLE_X, TITLE_Y, this.titleColor);
            for (DialogWord w : words) {
                w.render(sb);
            }
            for (LargeDialogOptionButton b : optionList) {
                b.render(sb);
            }
            for (LargeDialogOptionButton b : optionList) {
                b.renderCardPreview(sb);
            }
        }
    }

    static {
        gl = new GlyphLayout();
        words = new ArrayList();
        textDone = true;
        wordTimer = 0.0f;
        CHAR_SPACING = 8.0f * Settings.scale;
        LINE_SPACING = 38.0f * Settings.scale;
        DIALOG_MSG_X_TEXT = 455.0f * Settings.scale;
        DIALOG_MSG_Y_TEXT = Settings.EVENT_Y + 300.0f * Settings.scale;
        DIALOG_MSG_W_TEXT = 1000.0f * Settings.scale;
        DIALOG_MSG_X = DIALOG_MSG_X_TEXT;
        DIALOG_MSG_Y = DIALOG_MSG_Y_TEXT;
        DIALOG_MSG_W = DIALOG_MSG_W_TEXT;
        optionList = new ArrayList();
        selectedOption = -1;
        waitForInput = true;
    }
}

